#!/usr/bin/perl
# Usage: perl generate-demo.pl buildlogs/all.dats.txt

$infile = $ARGV[0];

open INFILE, "<$infile" or die "Couldn't open $infile";
while ($line = <INFILE>) {
  if ( ($arch,$compiler) = $line =~ m/NAME=(.*)-(gcc-[^\s]*).*=PASS/) {
    push @{ $results{$arch} }, $compiler;
  }
}
close(INFILE);

$header_str = <<END;
#!/bin/sh
# This script has one line for each known working toolchain
# for this architecture.  Uncomment the one you want.
# Generated by generate-demo.pl from buildlogs/all.dats.txt

set -ex
TARBALLS_DIR=\$HOME/downloads
RESULT_TOP=/opt/crosstool
export TARBALLS_DIR RESULT_TOP
GCC_LANGUAGES=\"c,c++\"
export GCC_LANGUAGES

# Really, you should do the mkdir before running this,
# and chown /opt/crosstool to yourself so you don't need to run as root.
mkdir -p \$RESULT_TOP

END

for $arch (keys %results) {
  $outfile = "demo-$arch.sh";
  open OUTFILE, ">$outfile" or die "Couldn't open $outfile";
  printf OUTFILE $header_str;
  $n = $#{ $results{$arch} };
  @{ $results{$arch} } = sort(@{ $results{$arch} });
  if ($n > 0) {
    foreach $j (0 .. $n) {
      if ( $j < $n ) {
        printf OUTFILE "#";
      }
      printf OUTFILE "eval `cat $arch.dat $results{$arch}[$j].dat` sh all.sh --notest\n";
    }
  }
  printf OUTFILE "\necho Done.\n";
  close(OUTFILE);
}
